program WinService;
//------------------------------------------------------------------------------
//  File name:      WinService.dpr
//  Last updated:   11/16/03
//  Author:         Sergey Mishkovskiy
//  Company:        USysWare, Inc.
//  Contact info:   usysware@comcast.net
//
//  Compatibility:  Borland Delphi for .NET
//
//  Description:    This is a .NET Windows service skeleton. To install the
//                  service use InstallUtil.exe utility, which comes with every
//                  runtime version of the .NET framework. For instance, on
//                  Windows XP and framework v1.1 it's located under
//                  C:\WINDOWS\Microsoft.NET\Framework\v1.1.4322 folder.
//                  To install the service run
//                  <<Path>\InstallUtil <Path>\WinService.exe> command
//                  (no brackets and with correct path). To uninstall the
//                  service run <<Path>\InstallUtil /u <Path>\WinService.exe>
//                  command (no brackets and with correct path).
//
//
// Installation:    Use InstallUtil.exe utility that comes with the framework
//                  to install the service. On Windows XP the installation
//                  command could look like:
//
// "C:\WINDOWS\Microsoft.NET\Framework\v1.1.4322\InstallUtil.exe" WinService.exe
//
//                  The installed pre-compiled service shows up as under
//                  'MyDelphiWinService' name in the services list.
//
// Uninstallation:  Use InstallUtil.exe utility that comes with the framework
//                  to uninstall the service. On Windows XP the installation
//                  command could look like:
//
// "C:\WINDOWS\Microsoft.NET\Framework\v1.1.4322\InstallUtil.exe" /u WinService.exe
//------------------------------------------------------------------------------

{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Data.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.ServiceProcess.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.XML.dll'}

uses
  System.Reflection,
  System.ServiceProcess,
  Service,
  ProjectInstaller in 'ProjectInstaller.pas';

{$REGION 'Program/Assembly Information'}
//
// General Information about an assembly is controlled through the following
// set of attributes. Change these attribute values to modify the information
// associated with an assembly.
//
[assembly: AssemblyTitle('')]
[assembly: AssemblyDescription('')]
[assembly: AssemblyConfiguration('')]
[assembly: AssemblyCompany('')]
[assembly: AssemblyProduct('')]
[assembly: AssemblyCopyright('')]
[assembly: AssemblyTrademark('')]
[assembly: AssemblyCulture('')]

//
// Version information for an assembly consists of the following four values:
//
//      Major Version
//      Minor Version 
//      Build Number
//      Revision
//
// You can specify all the values or you can default the Revision and Build Numbers 
// by using the '*' as shown below:

[assembly: AssemblyVersion('1.0.*')]

//
// In order to sign your assembly you must specify a key to use. Refer to the 
// Microsoft .NET Framework documentation for more information on assembly signing.
//
// Use the attributes below to control which key is used for signing. 
//
// Notes: 
//   (*) If no key is specified, the assembly is not signed.
//   (*) KeyName refers to a key that has been installed in the Crypto Service
//       Provider (CSP) on your machine. KeyFile refers to a file which contains
//       a key.
//   (*) If the KeyFile and the KeyName values are both specified, the 
//       following processing occurs:
//       (1) If the KeyName can be found in the CSP, that key is used.
//       (2) If the KeyName does not exist and the KeyFile does exist, the key 
//           in the KeyFile is installed into the CSP and used.
//   (*) In order to create a KeyFile, you can use the sn.exe (Strong Name) utility.
//       When specifying the KeyFile, the location of the KeyFile should be
//       relative to the project output directory which is
//       %Project Directory%\bin\<configuration>. For example, if your KeyFile is
//       located in the project directory, you would specify the AssemblyKeyFile 
//       attribute as [assembly: AssemblyKeyFile('..\\..\\mykey.snk')]
//   (*) Delay Signing is an advanced option - see the Microsoft .NET Framework
//       documentation for more information on this.
//
[assembly: AssemblyDelaySign(false)]
[assembly: AssemblyKeyFile('')]
[assembly: AssemblyKeyName('')]
{$ENDREGION}

begin
  WindowsService := TWindowsService.Create;
  System.ServiceProcess.ServiceBase.Run(WindowsService);
end.
